/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.pngwalk;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.URISplit;
import org.autoplot.imagedatasource.ImageDataSource;
import org.autoplot.pngwalk.PngWalkView;
import org.autoplot.pngwalk.ScalePerspectiveImageOp;
import org.autoplot.pngwalk.WalkUtil;
import org.das2.datum.DatumRange;
import org.das2.system.RequestProcessor;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileObject;
import org.das2.util.filesystem.FileSystem;
import org.imgscalr.Scalr;

public class WalkImage {
    private static final Logger logger = LoggerManager.getLogger((String)"autoplot.pngwalk");
    public static final String PROP_STATUS_CHANGE = "status";
    public static final String PROP_BADGE_CHANGE = "badgeChange";
    public static final int THUMB_SIZE = 400;
    private static final int SQUASH_FACTOR = 10;
    private static final int LOADED_IMAGE_COUNT_LIMIT = 10;
    private static final int LOADED_THUMB_COUNT_LIMIT = 400;
    final String uriString;
    private final URI imgURI;
    private BufferedImage im;
    private BufferedImage thumb;
    private Set<PngWalkView> observers = new HashSet<PngWalkView>();
    private Dimension thumbDimension;
    private BufferedImage squishedThumb;
    private BufferedImage sizeThumb;
    private int sizeThumbWidth = -1;
    private String caption;
    private long initLoadBirthTime;
    private Status status;
    private final ReentrantLock statusLock = new ReentrantLock();
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final boolean haveThumbs400;
    private static final BufferedImage missingImage = WalkImage.initMissingImage();
    private static final LinkedList<WalkImage> freshness = new LinkedList();
    private static final LinkedList<WalkImage> thumbFreshness = new LinkedList();
    DatumRange dr;

    public URI getUri() {
        if (this.imgURI != null) {
            return this.imgURI;
        }
        try {
            return new URI("");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public WalkImage(URI uri, boolean haveThumbs400) {
        this.imgURI = uri;
        this.haveThumbs400 = haveThumbs400;
        if (this.imgURI != null) {
            this.uriString = DataSetURI.fromUri((URI)uri);
            this.status = Status.UNKNOWN;
        } else {
            this.uriString = null;
            this.status = Status.MISSING;
        }
    }

    public Status getStatus() {
        return this.status;
    }

    private void setStatus(Status s) {
        logger.log(Level.FINER, "setStatus {0} {1}", new Object[]{s, this.caption});
        if (s == null) {
            throw new NullPointerException("status cannot be null");
        }
        Status oldStatus = this.status;
        this.status = s;
        this.pcs.firePropertyChange(PROP_STATUS_CHANGE, (Object)oldStatus, (Object)this.status);
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getCaption() {
        return this.caption;
    }

    public DatumRange getDatumRange() {
        return this.dr;
    }

    public void setDatumRange(DatumRange dr) {
        this.dr = dr;
    }

    public BufferedImage waitForImage() {
        BufferedImage localImage = this.getImage();
        while (localImage == null) {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(WalkImage.class.getName()).log(Level.SEVERE, null, ex);
            }
            localImage = this.getImage();
        }
        return localImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getImage() {
        Status lstatus = this.getStatus();
        if (lstatus == Status.MISSING) {
            return missingImage;
        }
        if (this.im == null && lstatus != Status.IMAGE_LOADING) {
            this.loadImage();
        }
        LinkedList<WalkImage> linkedList = freshness;
        synchronized (linkedList) {
            freshness.remove(this);
            freshness.addFirst(this);
        }
        return this.im;
    }

    public long getInitLoadBirthTime() {
        return this.initLoadBirthTime;
    }

    BufferedImage getImageIfLoaded() {
        return this.im;
    }

    public BufferedImage getThumbnail() {
        return this.getThumbnail(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized BufferedImage getThumbnail(int w, int h, boolean waitOk) {
        LinkedList<WalkImage> linkedList = thumbFreshness;
        synchronized (linkedList) {
            thumbFreshness.remove(this);
            thumbFreshness.addFirst(this);
        }
        if (this.sizeThumbWidth == w) {
            return this.sizeThumb;
        }
        if (waitOk) {
            BufferedImage theThumb = this.getThumbnail(true);
            if (theThumb == null) {
                return PngWalkView.loadingImage;
            }
            long t0 = System.currentTimeMillis();
            this.sizeThumb = Scalr.resize((BufferedImage)theThumb, (int)(w > h ? w : h), (BufferedImageOp[])new BufferedImageOp[0]);
            long method1time = System.currentTimeMillis() - t0;
            if (method1time < 20L) {
                t0 = System.currentTimeMillis();
                ScalePerspectiveImageOp resizeOp = new ScalePerspectiveImageOp(theThumb.getWidth(), theThumb.getHeight(), 0, 0, w, h, 0, 1, 1, 0.0, false);
                this.sizeThumb = resizeOp.filter(theThumb, null);
                long method2time = System.currentTimeMillis() - t0;
                logger.log(Level.FINE, "method1: {0}ms method2: {1}ms {2} {3}", new Object[]{method1time, method2time, theThumb.getWidth(), this.sizeThumb.getWidth()});
            } else {
                logger.log(Level.FINE, "imgscalr used to resize: {0}", new Object[]{method1time});
            }
            this.sizeThumbWidth = w;
            return this.sizeThumb;
        }
        return PngWalkView.loadingImage;
    }

    public static BufferedImage rotateImage(BufferedImage img, int angle) {
        double sin = Math.abs(Math.sin(Math.toRadians(angle)));
        double cos = Math.abs(Math.cos(Math.toRadians(angle)));
        int w = img.getWidth(null);
        int h = img.getHeight(null);
        int neww = (int)Math.floor((double)w * cos + (double)h * sin);
        int newh = (int)Math.floor((double)h * cos + (double)w * sin);
        BufferedImage bimg = new BufferedImage(neww, newh, img.getType());
        Graphics2D g = bimg.createGraphics();
        g.translate((double)(neww - w) / 2.0, (double)(newh - h) / 2.0);
        g.rotate(Math.toRadians(angle), (double)w / 2.0, (double)h / 2.0);
        g.drawRenderedImage(img, null);
        g.dispose();
        return bimg;
    }

    public BufferedImage readImage(File f) throws IllegalArgumentException, IOException {
        logger.entering("WalkImage", "readImage");
        try {
            BufferedImage lim = ImageIO.read(f);
            if (lim == null) {
                logger.log(Level.INFO, "fail to read image: {0}", f);
                logger.exiting("WalkImage", "readImage");
                return missingImage;
            }
            logger.log(Level.FINER, "image has been read {0}x{1}", new Object[]{lim.getWidth(), lim.getHeight()});
            if (lim.getType() == 0) {
                BufferedImage imNew = new BufferedImage(lim.getWidth(), lim.getHeight(), 2);
                imNew.getGraphics().drawImage(lim, 0, 0, null);
                lim = imNew;
                logger.log(Level.FINER, "image converted to ARGB");
            }
            long t0 = System.currentTimeMillis();
            try (FileInputStream in = new FileInputStream(f);){
                Map meta = ImageDataSource.getJpegExifMetaData((InputStream)in);
                String orient = String.valueOf(meta.get("Orientation"));
                if (orient.startsWith("Right side, top")) {
                    lim = WalkImage.rotateImage(lim, 90);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            logger.log(Level.FINER, "check rotate (millis): {0}", System.currentTimeMillis() - t0);
            logger.exiting("WalkImage", "readImage");
            return lim;
        }
        catch (IOException ex) {
            return missingImage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void getThumbnailImmediately() {
        block26: {
            WalkImage.logger.log(Level.FINER, "getThumbnailImmediately {0}", this.caption);
            if (!this.hasObservers()) {
                WalkImage.logger.log(Level.FINE, "no observers {0}", this.imgURI);
            }
            try {
                if (this.haveThumbs400) {
                    fsRoot = DataSetURI.toUri((String)(URISplit.parse((URI)this.imgURI).path + "thumbs400"));
                    fs = FileSystem.create((URI)fsRoot);
                    fo = fs.getFileObject((s = DataSetURI.fromUri((URI)this.imgURI)).substring(s.lastIndexOf(47) + 1));
                    localFile /* !! */  = fo.getFile();
                    rawThumb = this.readImage(localFile /* !! */ );
                    if (rawThumb == null) {
                        throw new RuntimeException("Unable to read: " + localFile /* !! */ );
                    }
                    break block26;
                }
                throw new IOException("silly code to jump");
            }
            catch (IOException ex) {
                WalkImage.logger.log(Level.FINER, "attempt to load thumbnail in thumbs400 failed, load original: {0}", this.caption);
                if (this.im == null) {
                    this.loadImage();
                    return;
                }
                rawThumb = this.im;
            }
            catch (IllegalArgumentException ex) {
                if (this.im == null) {
                    this.loadImageImmediately();
                    return;
                }
                rawThumb = this.im;
            }
        }
        aspect = (double)rawThumb.getWidth() / (double)rawThumb.getHeight();
        height = (int)Math.round(Math.sqrt(160000.0 / (aspect * aspect + 1.0)));
        width = (int)Math.round((double)height * aspect);
        this.statusLock.lock();
        try {
            this.thumb = WalkUtil.resizeImage(rawThumb, width, height);
            this.thumbDimension = new Dimension(width, height);
            switch (1.$SwitchMap$org$autoplot$pngwalk$WalkImage$Status[this.status.ordinal()]) {
                case 1: {
                    this.setStatus(Status.THUMB_LOADED);
                    ** break;
lbl39:
                    // 1 sources

                    break;
                }
                case 2: {
                    this.setStatus(Status.THUMB_LOADED);
                    ** break;
lbl43:
                    // 1 sources

                    break;
                }
                ** default:
lbl45:
                // 1 sources

                break;
            }
        }
        finally {
            this.statusLock.unlock();
        }
        localFile /* !! */  = WalkImage.thumbFreshness;
        synchronized (localFile /* !! */ ) {
            WalkImage.thumbFreshness.remove(this);
            WalkImage.thumbFreshness.addFirst(this);
        }
        clear = new LinkedList<WalkImage>();
        var7_13 = WalkImage.thumbFreshness;
        synchronized (var7_13) {
            while (WalkImage.thumbFreshness.size() > 400) {
                old = WalkImage.thumbFreshness.getLast();
                WalkImage.thumbFreshness.remove(old);
                clear.add(old);
            }
        }
        while (clear.size() > 0) {
            var8_15 = old = (WalkImage)clear.poll();
            synchronized (var8_15) {
                WalkImage.logger.log(Level.FINE, "unloading thumbnail for {0}", old);
                old.setStatus(Status.SIZE_THUMB_LOADED);
                old.clearImages();
            }
        }
    }

    public synchronized Dimension getThumbnailDimension(boolean loadIfNeeded) {
        if (loadIfNeeded) {
            this.getThumbnail(loadIfNeeded);
        }
        return this.thumbDimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getThumbnail(boolean loadIfNeeded) {
        Object object = thumbFreshness;
        synchronized (object) {
            thumbFreshness.remove(this);
            thumbFreshness.addFirst(this);
        }
        this.statusLock.lock();
        try {
            switch (this.status) {
                case THUMB_LOADING: {
                    object = null;
                    return object;
                }
                case THUMB_LOADED: {
                    if (this.thumb == null) {
                        throw new RuntimeException("thumb should not be null");
                    }
                    object = this.thumb;
                    return object;
                }
                case IMAGE_LOADED: {
                    object = this.thumb;
                    return object;
                }
                case ERROR: {
                    object = this.thumb;
                    return object;
                }
                case MISSING: {
                    object = missingImage;
                    return object;
                }
                case SIZE_THUMB_LOADED: 
                case UNKNOWN: {
                    if (!loadIfNeeded) {
                        object = null;
                        return object;
                    }
                    this.setStatus(Status.THUMB_LOADING);
                    object = this.maybeReturnThumb(loadIfNeeded);
                    return object;
                }
                case IMAGE_LOADING: {
                    object = this.maybeReturnThumb(loadIfNeeded);
                    return object;
                }
            }
            throw new IllegalArgumentException("Encountered invalid status in walk image.");
        }
        finally {
            this.statusLock.unlock();
        }
    }

    private BufferedImage maybeReturnThumb(boolean loadIfNeeded) {
        if (this.thumb != null) {
            return this.thumb;
        }
        if (!loadIfNeeded) {
            return null;
        }
        Runnable r = () -> this.getThumbnailImmediately();
        RequestProcessor.invokeLater((Runnable)r);
        return null;
    }

    public BufferedImage getSquishedThumbnail() {
        return this.getSquishedThumbnail(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getSquishedThumbnail(boolean loadIfNeeded) {
        if (this.status == Status.MISSING) {
            return missingImage;
        }
        BufferedImage lsquishedThumb = this.getSquishedThumb();
        if (lsquishedThumb == null) {
            WalkImage walkImage = this;
            synchronized (walkImage) {
                if (this.thumb == null && this.getThumbnail(loadIfNeeded) == null) {
                    return null;
                }
                if (this.thumb != null) {
                    ScalePerspectiveImageOp resizeOp = new ScalePerspectiveImageOp(this.thumb.getWidth(), this.thumb.getHeight(), 0, 0, this.thumb.getWidth() / 10, this.thumb.getHeight(), 0, 1, 1, 0.0, false);
                    lsquishedThumb = this.squishedThumb = resizeOp.filter(this.thumb, null);
                }
            }
        }
        return lsquishedThumb;
    }

    private synchronized BufferedImage getSquishedThumb() {
        return this.squishedThumb;
    }

    private synchronized void clearImages() {
        this.squishedThumb = null;
        this.thumb = null;
        this.im = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadImageImmediately() {
        logger.log(Level.FINER, "loadImageImmediately {0}", this.caption);
        try {
            BufferedImage lthumb;
            WalkImage walkImage;
            FileSystem fs;
            String s;
            URI fsRoot = DataSetURI.toUri((String)URISplit.parse((URI)this.imgURI).path);
            if (fsRoot.getPath().length() == 0) {
                s = this.imgURI.toASCIIString();
                int i = s.lastIndexOf("/");
                fs = FileSystem.create((String)s.substring(0, i));
            } else {
                fs = FileSystem.create((URI)fsRoot);
            }
            s = DataSetURI.fromUri((URI)this.imgURI);
            FileObject fo = fs.getFileObject(s.substring(s.lastIndexOf(47) + 1));
            File localFile = fo.getFile();
            this.im = this.readImage(localFile);
            if (this.im == null) {
                throw new RuntimeException("unable to read: " + localFile);
            }
            LinkedList<WalkImage> linkedList = freshness;
            synchronized (linkedList) {
                freshness.remove(this);
                freshness.addFirst(this);
            }
            LinkedList<WalkImage> clear = new LinkedList<WalkImage>();
            LinkedList<WalkImage> linkedList2 = freshness;
            synchronized (linkedList2) {
                while (freshness.size() > 10) {
                    WalkImage old = freshness.getLast();
                    freshness.remove(old);
                    clear.add(old);
                }
            }
            while (!clear.isEmpty()) {
                WalkImage old;
                walkImage = old = (WalkImage)clear.poll();
                synchronized (walkImage) {
                    logger.log(Level.FINE, "unloading image for {0}", old);
                    old.im = null;
                    if (old.getStatus() == Status.IMAGE_LOADED) {
                        if (old.thumb == null) {
                            old.setStatus(Status.UNKNOWN);
                        } else {
                            old.setStatus(Status.THUMB_LOADED);
                        }
                    }
                }
            }
            walkImage = this;
            synchronized (walkImage) {
                lthumb = this.thumb;
            }
            if (lthumb == null) {
                this.getThumbnailImmediately();
            }
            this.setStatus(Status.IMAGE_LOADED);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            this.setStatus(Status.MISSING);
            throw new RuntimeException(ex);
        }
    }

    private void loadImage() {
        logger.log(Level.FINER, "loadImage {0}", this.caption);
        Status lstatus = this.status;
        if (lstatus == Status.IMAGE_LOADING || lstatus == Status.IMAGE_LOADED) {
            return;
        }
        Runnable r = () -> this.loadImageImmediately();
        this.setStatus(Status.IMAGE_LOADING);
        this.initLoadBirthTime = System.currentTimeMillis();
        RequestProcessor.invokeLater((Runnable)r);
    }

    private static BufferedImage initMissingImage() {
        BufferedImage missing = new BufferedImage(200, 200, 2);
        Graphics2D g2 = missing.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setColor(Color.GRAY);
        FontMetrics fm = g2.getFontMetrics(g2.getFont());
        String msg = "(Missing)";
        g2.drawString(msg, (200 - fm.stringWidth(msg)) / 2, 100);
        return missing;
    }

    public void removeObserver(PngWalkView obs) {
        this.observers.remove(obs);
    }

    public void addObserver(PngWalkView obs) {
        this.observers.add(obs);
    }

    public boolean hasObservers() {
        return !this.observers.isEmpty();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public String toString() {
        return this.getCaption() == null ? this.uriString : this.getCaption();
    }

    public static enum Status {
        UNKNOWN,
        SIZE_THUMB_LOADED,
        THUMB_LOADING,
        THUMB_LOADED,
        IMAGE_LOADING,
        IMAGE_LOADED,
        MISSING,
        ERROR;

    }
}

